/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class SceKernelTls {
    public String name;
    public int attr;
    public int blockSize;
    public int alignedBlockSize;
    public int numberBlocks;
    public int uid;
    private static final String uidPurpose = "SceKernelTls";
    private SysMemUserForUser.SysMemInfo sysMemInfo;
    private int[] threadIds;

    public SceKernelTls(String name, int partitionId, int attr, int blockSize, int alignedBlockSize, int numberBlocks, int alignment) {
        int type;
        blockSize = Utilities.alignUp(blockSize, 3);
        this.name = name;
        this.attr = attr;
        this.blockSize = blockSize;
        this.alignedBlockSize = alignedBlockSize;
        this.numberBlocks = numberBlocks;
        int n = type = alignment == 0 ? 0 : 3;
        if ((attr & 0x4000) != 0) {
            type = alignment == 0 ? 1 : 4;
        }
        int size = alignedBlockSize * numberBlocks;
        this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(partitionId, name, type, size, alignment);
        this.uid = SceUidManager.getNewUid(uidPurpose);
        this.threadIds = new int[numberBlocks];
    }

    public void free() {
        Memory.getInstance().memset(this.sysMemInfo.addr, (byte)0, this.sysMemInfo.allocatedSize);
        Modules.SysMemUserForUserModule.free(this.sysMemInfo);
        this.sysMemInfo = null;
        SceUidManager.releaseUid(this.uid, uidPurpose);
        this.uid = -1;
    }

    public int getBaseAddress() {
        if (this.sysMemInfo == null) {
            return 0;
        }
        return this.sysMemInfo.addr;
    }

    public void freeTlsAddress() {
        if (this.sysMemInfo == null) {
            return;
        }
        int currentThreadId = Modules.ThreadManForUserModule.getCurrentThreadID();
        for (int i = 0; i < this.threadIds.length; ++i) {
            if (this.threadIds[i] != currentThreadId) continue;
            this.threadIds[i] = 0;
            break;
        }
    }

    public int getTlsAddress() {
        if (this.sysMemInfo == null) {
            return 0;
        }
        int currentThreadId = Modules.ThreadManForUserModule.getCurrentThreadID();
        int block = -1;
        for (int i = 0; i < this.threadIds.length; ++i) {
            if (this.threadIds[i] != currentThreadId) continue;
            block = i;
            break;
        }
        boolean needsClear = false;
        if (block < 0) {
            for (int i = 0; i < this.threadIds.length; ++i) {
                if (this.threadIds[i] != 0) continue;
                block = i;
                this.threadIds[block] = currentThreadId;
                needsClear = true;
                break;
            }
            if (block < 0) {
                return 0;
            }
        }
        int address = this.sysMemInfo.addr + block * this.alignedBlockSize;
        if (needsClear) {
            Memory.getInstance().memset(address, (byte)0, this.blockSize);
        }
        return address;
    }
}

